package cn.com.duiba.cloud.order.center.api.model.param.logistics;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description 批量任务创建
 * @Author dangcang
 * @Date 2021/11/11 11:15 上午
 **/
@Data
public class CreateBatchTaskParam implements Serializable {

    private static final long serialVersionUID = 4071327651485968934L;
    /**
     * 任务类型
     * @see cn.com.duiba.cloud.order.center.api.enums.BatchTypeEnum
     */
    private Integer batchType;

    /**
     * 销售人id
     */
    private Long sellerId;

    /**
     * 销售人类型
     */
    private Integer sellerType;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 文件路径
     */
    private String filePath;

    /**
     * 操作人id
     */
    private Long operatorId;

    /**
     * 操作人
     */
    private String operatorName;

    /**
     * 操作备注
     * templateType = 4、5必填
     */
    private String operatorRemark;
}