package cn.com.duiba.cloud.order.center.api.model.param.order;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/4/6 7:28 下午
 **/
@Data
public class ExceptionHandleParam implements Serializable {

    private static final long serialVersionUID = 3556594273743295042L;
    /**
     * 主订单号
     */
    @NotBlank(message = "主订单号不能为空")
    private String orderCode;

    /**
     * 兑吧后台子订单维度 开发者后台主订单维度
     */
    private Long orderSort;

    /**
     * 处理结果 成功= true 失败的false
     */
    @NotNull(message = "处理结果不能为空")
    private Boolean success;

    /**
     * 失败原因 失败的时候一定有
     * 成功的时候不一定有 租户后台成功不需要传值
     */
    private String reason;

    /**
     * 操作备注
     */
    private String remark;

    /**
     * 操作人id
     */
    @NotNull(message = "操作人不能为空")
    private Long operatorId;

    /**
     * 操作人名称
     */
    @NotBlank(message = "操作人名称不能为空")
    private String operatorName;

    /**
     * 异常订单优惠券参数
     * 优惠券订单才需要传
     */
    private CouponExceptionParam couponExceptionParam;
}