package cn.com.duiba.cloud.order.center.api.model.param.order;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/4/2 4:02 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class UserOrderQueryParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = 283971009617380951L;
    /**
     * 买家id
     */
    @NotNull(message = "买家id不能为空")
    private Long buyerId;

    /**
     * 买家类型
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.AccountTypeEnum
     */
    @NotNull(message = "买家类型不能为空")
    private Integer buyerType;

    /**
     * 购买方AppId
     */
    @NotNull(message = "购买方AppId不能为空")
    private Long buyerAppId;

    /**
     * 子订单状态
     */
    private List<Integer> orderStatusList;
}