package cn.com.duiba.cloud.order.center.api.model.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 子订单信息
 * @Author dangcang
 * @Date 2021/11/10 4:13 下午
 **/
@Data
public class SubOrderDTO implements Serializable {

    private static final long serialVersionUID = -953811173873911141L;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * orderSort
     */
    private Long orderSort;

    /**
     * sku渠道id
     */
    private String skuChannelId;

    /**
     * 商品快照id
     */
    private String snapshotId;

    /**
     * 获取skuId
     */
    private Long skuId;

    /**
     * 商品spu Id
     */
    private Long spuId;

    /**
     * 商品来源
     */
    private Integer goodsSource;

    /**
     * 商品类型
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuTypeEnum
     */
    private Integer goodsType;

    /**
     * 商品子类型
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.SubSpuTypeEnum
     */
    private Integer subGoodsType;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 销售价格
     */
    private Long salePrice;

    /**
     * 积分单价
     */
    private Long creditsPrice;

    /**
     * 成本价
     */
    private Long costPrice;

    /**
     * 划线价(分)
     */
    private Long facePrice;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 商品图片
     */
    private String imgSrc;

    /**
     * 商品属性
     */
    private String attr;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 购买数量
     */
    private Long saleNumber;

    /**
     * 订单来源：和orderType合用
     */
    private String bizId;

    /**
     * 订单来源类型 字面量 如大转盘
     */
    private String bizType;

    /**
     * 支付信息
     */
    private List<PaymentDTO> paymentDTOS;

    /**
     * 优惠项信息
     */
    private List<DiscountDTO> discountDTOS;

}