package cn.com.duiba.cloud.order.center.api.model.param.aftersale;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/11/10 6:12 下午
 **/
@Getter
@Setter
public class AfterSaleQueryParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = -4991779361883030164L;
    /**
     * 订单编号
     */
    private Long orderCode;

    /**
     * 子订单序号
     */
    private Long orderSort;

    /**
     * 售后单id
     */
    private Long afterSaleId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 用户类型
     */
    private Integer userType;

    /**
     * 申请售后开始时间 毫秒级时间戳
     */
    private Long afterSaleStartTime;

    /**
     * 申请售后结束时间 毫秒级时间戳
     */
    private Long afterSaleEndTime;
}