package cn.com.duiba.cloud.order.center.api.model.param.order;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/11/11 11:38 上午
 **/
@Data
public class PaymentParam implements Serializable {

    private static final long serialVersionUID = 1731785971341878139L;

    /**
     * 支付类型
     * @see cn.com.duiba.cloud.order.center.api.enums.PayTypeEnum
     */
    private Integer payType = 1;

    /**
     * 支付数量 虚拟货币单位 个
     */
    private Long payNumber;

    /**
     * 支付批次
     */
    private Integer paymentLevel;

    /**
     * 开始支付时间 毫秒级时间戳
     */
    private Long paymentStartTime;

    /**
     * 截止支付时间 毫秒级时间戳
     */
    private Long paymentEndTime;
}