package cn.com.duiba.cloud.order.center.api.model.param.virtual;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/4/3 5:04 下午
 **/
@Data
public class VirtualGoodsDeliveryQueryParam implements Serializable {

    private static final long serialVersionUID = -8432460303408169184L;
    /**
     * 主订单号
     */
    @NotBlank(message = "主订单号不能为空")
    private String orderCode;

    /**
     * 子订单序号
     */
    @NotNull(message = "子订单序号不能为空")
    private Long orderSort;

    /**
     * 商品快照id
     */
    private String snapshotId;
}