package cn.com.duiba.cloud.order.center.api.openapi.model.param;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/1/25 3:46 下午
 **/
@Data
public class OpenDeliverGoodsParam implements Serializable {

    private static final long serialVersionUID = 2768372620991068070L;
    /**
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String orderCode;

    /**
     * 物流单
     */
    @Valid
    @NotEmpty(message = "发货参数不能为空")
    private List<OpenCreateLogisticsParam> logisticsParams;

}