package cn.com.duiba.cloud.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.center.api.model.dto.order.PaymentDTO;

import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/5/25 5:21 下午
 **/
@AdvancedFeignClient
public interface RemoteOrderPaymentReadService {

    /**
     * 根据订单号列表获取订单支付项信息
     * @param orderCodeList
     * @param bizType
     * @see cn.com.duiba.cloud.order.center.api.enums.PaymentBizTypeEnum
     * @return
     * @throws BizException
     */
    List<PaymentDTO> findPaymentByOrderCodeList(List<String> orderCodeList, Integer bizType) throws BizException;
}