package cn.com.duiba.cloud.order.service.api.enums;

import lombok.Getter;

/**
 * @Description 订单状态枚举类
 * @Author dangcang
 * @Date 2021/11/8 2:13 下午
 **/
@Getter
public enum OrderStatusEnum {

    WAIT_PAY(10,"待支付"),
    WAIT_REVIEW(20,"待审核"),
    WAIT_SHIPMENT(30,"待发货"),
    WAIT_TAKE_DELIVERY(40,"待收货"),
    ORDER_COMPLETION(50,"交易完成"),

    ORDER_SUCCESS(90,"交易成功"),
    ORDER_CLOSE(91,"交易关闭"),
    ORDER_ERROR(99,"异常状态"),
    ;

    private Integer status;

    private String desc;

    OrderStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

}