package cn.com.duiba.cloud.order.service.api.model.dto;

import lombok.Data;

import java.io.Serializable;

;

/**
 * @Description 优惠信息
 * @Author dangcang
 * @Date 2021/11/15 11:46 上午
 **/
@Data
public class DiscountDTO implements Serializable {

    private static final long serialVersionUID = -1724937888746135161L;

    /**
     * 订单code
     */
    private String orderCode;

    /**
     * 子订单序号
     */
    private Integer orderSort;

    /**
     * 优惠源
     * @see cn.com.duiba.cloud.order.service.api.enums.DiscountSourceEnum
     */
    private Integer discountSource;

    /**
     * 优惠类型
     * @see cn.com.duiba.cloud.order.service.enums.PayTypeEnum
     */
    private Integer discountType;

    /**
     * 优惠数量，法币单位：分，积分单位：个
     */
    private Long discountNum;
}