package cn.com.duiba.cloud.order.service.api.model.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 用户订单详情
 * @Author dangcang
 * @Date 2021/11/16 5:16 下午
 **/
@Data
public class UserOrderDetailDTO implements Serializable {

    private static final long serialVersionUID = 1445151790965241020L;
    /**
     * 下单时间
     */
    private Long orderTime;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 购买者用户id
     */
    private Long userId;

    /**
     * appId
     */
    private Long appId;

    /**
     * 商家id
     */
    private Long storeId;

    /**
     * 订单来源
     */
    private Long orderSource;

    /**
     * 购买者类型
     */
    private Integer userType;

    /**
     * 子订单信息
     */
    List<SubOrderGoodsDTO> subOrderGoodsDTOS;

}