package cn.com.duiba.cloud.order.service.api.model.param;

import lombok.Data;

import java.io.Serializable;
import java.util.List;


/**
 * @Description 申请售后
 * @Author dangcang
 * @Date 2021/11/11 10:00 上午
 **/
@Data
public class CreateAfterSaleParam implements Serializable {

    private static final long serialVersionUID = -386661956441466429L;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 子订单序号
     */
    private Integer orderSort;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 用户类型
     */
    private Integer userType;

    /**
     * 售后类型
     * @see cn.com.duiba.cloud.order.service.api.enums.AfterSaleTypeEnum
     */
    private Integer afterSaleType;

    /**
     * 售后方式
     * @see cn.com.duiba.cloud.order.service.api.enums.AfterSaleWayEnum
     */
    private Integer afterSaleWay;

    /**
     * 售后原因
     */
    private String afterSaleReason;

    /**
     * 售后凭证 英文逗号,分割
     */
    private List<String> imgSrcList;
}