package cn.com.duiba.cloud.order.service.api.model.param;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 商品信息
 * @Author dangcang
 * @Date 2021/11/10 2:02 下午
 **/
@Data
public class GoodsParam implements Serializable {

    private static final long serialVersionUID = -3367088637140958493L;
    /**
     * 上架项id
     */
    private Long saleId;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 商品类型
     * @see 商品类型
     */
    private Integer goodsType;

    /**
     * 商品来源：自有商品 自有供应商 兑吧商品
     */
    private Integer goodsSource;

    /**
     * 销售价格 分
     */
    private Long salePrice;

    /**
     * 实付价格 分
     */
    private Integer paymentPrice;

    /**
     * 购买数量
     */
    private Long saleNumber;

    /**
     * 备注
     */
    private String remark;

    /**
     * 优惠相关
     */
    private List<DiscountParam> discountParams;

    /**
     * 支付相关
     */
    private List<PaymentParam> paymentParams;

    /**
     * 采购流水 先销后采 才需要
     */
    private List<PurchaseDetailParam> purchaseDetailParams;

}