package cn.com.duiba.cloud.order.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.service.api.model.param.OrderRemarkParam;
import cn.com.duiba.cloud.order.service.api.model.param.OrderRemindParam;
import cn.com.duiba.cloud.order.service.api.model.param.UpdateOrderExtraParam;

/**
 * @Description 订单扩展信息写相关
 * @Author dangcang
 * @Date 2021/11/14 11:24 上午
 **/
@AdvancedFeignClient
public interface RemoteOrderExtraWriteService {

    /**
     * 租户订单备注
     * 填了orderSort 就是子订单级别的备注
     * @param param
     * @return
     * @throws BizException
     */
    Boolean tenantOrderRemark(OrderRemarkParam param) throws BizException;

    /**
     * 订单提醒
     * 填了orderSort 就是子订单级别的提醒
     * @param param
     * @return
     * @throws BizException
     */
    Boolean orderRemind(OrderRemindParam param) throws BizException;

    /**
     * 修改订单扩展信息
     * @param param
     * @return
     * @throws BizException
     */
    Boolean updateOrderExtra(UpdateOrderExtraParam param) throws BizException;

}