package cn.com.duiba.cloud.order.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.service.api.model.dto.OrderDTO;
import cn.com.duiba.cloud.order.service.api.model.dto.OrderDetailDTO;
import cn.com.duiba.cloud.order.service.api.model.dto.UserOrderDetailDTO;
import cn.com.duiba.cloud.order.service.api.model.param.OrderQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @Description 订单相关读操作接口
 * @Author dangcang
 * @Date 2021/11/10 1:37 下午
 **/
@AdvancedFeignClient
public interface RemoteOrderReadService {

    /**
     * 分页查询订单接口--后台
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<OrderDTO> find(OrderQueryParam param) throws BizException;

    /**
     * 获取订单详情--后台
     * @param orderCode
     * @return
     * @throws BizException
     */
    OrderDetailDTO getOrderDetail(String orderCode) throws BizException;

    /**
     * 用户获取订单详情
     * @param orderCode
     * @return
     * @throws BizException
     */
    UserOrderDetailDTO getUserOrderDetail(String orderCode) throws BizException;
}