package cn.com.duiba.cloud.order.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.service.api.model.dto.PayOrderDTO;
import cn.com.duiba.cloud.order.service.api.model.param.CreateOrderParam;
import cn.com.duiba.cloud.order.service.api.model.param.OrderRemarkParam;
import cn.com.duiba.cloud.order.service.api.model.param.UpdateOrderStatusParam;

/**
 * @Description 订单相关写操作接口
 * @Author dangcang
 * @Date 2021/11/10 1:35 下午
 **/
@AdvancedFeignClient
public interface RemoteOrderWriteService {

    //todo 审批单

    /**
     * 创建订单
     * @param param
     * @return
     * @throws BizException
     */
    PayOrderDTO createOrder(CreateOrderParam param) throws BizException;

    /**
     * 用户订单备注
     * 子订单级别的备注
     * @param param
     * @return
     * @throws BizException
     */
    Boolean userSubOrderRemark(OrderRemarkParam param) throws BizException;

    /**
     * 修改订单状态--同时会发出状态变更MQ
     * @param param
     * @return
     * @throws BizException
     */
    Boolean updateOrderStatus(UpdateOrderStatusParam param) throws BizException;
}