package cn.com.duiba.cloud.order.service.api.enums;

import lombok.Getter;

/**
 * @Description 订单类型枚举类
 * @Author dangcang
 * @Date 2021/11/8 2:04 下午
 **/
@Getter
public enum OrderTypeEnum {

    EXCHANGE_ACTIVITY(1,"兑换活动"),
    NORMAL(2, "普通toC订单"),
    SALE(3, "toB销售订单:会关联出B2B采购订单"),
    PURCHASE(4, "B2B采购订单"),
    ;

    private Integer type;

    private String desc;

    OrderTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }


}