package cn.com.duiba.cloud.order.service.api.model.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 用户订单详情
 * @Author dangcang
 * @Date 2021/11/16 5:16 下午
 **/
@Data
public class OrderDetailDTO implements Serializable {

    private static final long serialVersionUID = 1445151790965241020L;

    /**
     * 订单商品名称
     */
    private String orderName;

    /**
     * 下单时间
     */
    private Long orderTime;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单来源：和orderType合用
     */
    private String bizId;

    /**
     * 商品来源 销售订单没用到 不需要管
     */
    private Integer goodsSource;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * appId
     */
    private Long appId;

    /**
     * 销售方类型
     */
    private Integer sellerType;

    /**
     * 销售方id
     */
    private Long sellerId;

    /**
     * 购买者用户id
     */
    private Long buyerId;

    /**
     * 购买者类型
     */
    private Integer buyerType;

    /**
     * 子订单信息
     */
    List<SubOrderGoodsDTO> subOrderGoodsDTOS;

}