package cn.com.duiba.cloud.order.service.api.model.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description CreateOrderDTO
 * @Author dangcang
 * @Date 2021/11/10 1:53 下午
 **/
@Data
public class PayOrderDTO implements Serializable {

    private static final long serialVersionUID = -4644499577953202388L;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 购买人id
     */
    private Long buyerId;

    /**
     * 商品 子订单序号
     */
    private List<GoodsSortDTO> goodsSortDTOS;

    /**
     * 子订单支付信息
     */
    private List<PaymentDTO> paymentDTOS;

    /**
     * 子订单优惠项信息
     */
    private List<DiscountDTO> discountDTOS;

}