package cn.com.duiba.cloud.order.service.api.model.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/1/6 9:40 上午
 **/
@Data
public class SubOrderDTO implements Serializable {

    private static final long serialVersionUID = 4857519296917214653L;
    /**
     * 提供下次查询时的scrollId scroll查询时返回此字段,
     */
    private String scrollId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 子订单序号
     */
    private Long orderSort;

    /**
     * 下单时间
     */
    private Long orderTime;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 购买数量
     */
    private Long saleNumber;

    /**
     * 销售价格
     */
    private Long salePrice;

    /**
     * 子订单状态
     */
    private Integer subOrderStatus;

    /**
     * 售后状态
     */
    private Integer afterSaleStatus;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品类型
     */
    private Integer goodsType;

    /**
     * 购买人id
     */
    private Long buyerId;

    /**
     * 购买人类型
     */
    private Integer buyerType;

    /**
     * 销售人id
     */
    private Long sellerId;

    /**
     * 销售人类型
     */
    private Integer sellerType;

    /**
     * sku渠道id
     */
    private String skuChannelId;

    /**
     * 商品快照id
     */
    private String snapshotId;

    /**
     * 获取skuId
     */
    private Long skuId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 扩展信息查询
     */
    private List<OrderExtraDTO> orderExtraDTOS;

    /**
     * 交易相关
     */
    private List<PaymentDTO> paymentDTOS;

    /**
     * 优惠相关
     */
    private List<DiscountDTO> discountDTOS;
}