package cn.com.duiba.cloud.order.service.api.model.param;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 商品信息
 * @Author dangcang
 * @Date 2021/11/10 2:02 下午
 **/
@Data
public class GoodsParam implements Serializable {

    private static final long serialVersionUID = -3367088637140958493L;

    /**
     * 子订单序号
     */
    private Long orderSort;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品类型
     *
     */
    private Integer goodsType;

    /**
     * 商品所有人类型
     */
    private Integer ownType;

    /**
     * 商品所有人id
     */
    private Long ownId;

    /**
     * 预占场景泛id，如活动id<br>
     * 如果是预占消耗库存，必填
     */
    private Long generalId;

    /**
     * 预占场景泛类型，{@link cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum}<br>
     * 如果是预占消耗库存，必填
     */
    private Integer generalType;

    /**
     * 商品快照id
     */
    private String snapshotId;

    /**
     * 销售价格 分
     */
    private Long salePrice;

    /**
     * 购买数量
     */
    private Long saleNumber;

    /**
     * 备注
     */
    private String remark;

    /**
     * sku渠道id
     */
    private String skuChannelIds;

    /**
     * 优惠相关
     */
    private List<DiscountParam> discountParams;

    /**
     * 支付相关
     */
    private List<PaymentParam> paymentParams;

}