package cn.com.duiba.cloud.order.service.api.model.param;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description 订单查询参数
 * @Author dangcang
 * @Date 2021/11/10 3:05 下午
 **/
@Getter
@Setter
public class UserOrderQueryParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = 149208407594709069L;
    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 买家id
     */
    private Long userId;

    /**
     * 买家类型
     */
    private Integer userType;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 下单开始时间 毫秒级时间戳
     */
    private Date orderStartTime;

    /**
     * 下单截止时间 毫秒级时间戳
     */
    private Date orderEndTime;

    /**
     * 订单来源
     */
    private String orderSource;

    /**
     * 商品类型
     */
    private Integer goodsType;

    /**
     * 商品来源
     */
    private Integer goodsSource;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单状态
     */
    private Integer orderStatus;
}