package cn.com.duiba.cloud.order.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.service.api.model.dto.AfterSaleDTO;
import cn.com.duiba.cloud.order.service.api.model.dto.AfterSaleDetailDTO;
import cn.com.duiba.cloud.order.service.api.model.param.AfterSaleQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @Description 售后单相关读操作接口
 * @Author dangcang
 * @Date 2021/11/10 6:07 下午
 **/
@AdvancedFeignClient
public interface RemoteAfterSaleReadService {

    //todo 一期不做

    /**
     * 分页查询售后单接口--后台
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<AfterSaleDTO> find(AfterSaleQueryParam param) throws BizException;

    /**
     * 获取售后单详情
     * @param afterSaleId
     * @return
     * @throws BizException
     */
    AfterSaleDetailDTO afterSaleDetail(Long afterSaleId) throws BizException;


}