package cn.com.duiba.cloud.order.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.service.api.model.dto.OrderExtraDTO;
import cn.com.duiba.cloud.order.service.api.model.param.OrderExtraQueryParam;

import java.util.List;

/**
 * @Description 订单扩展信息读相关
 * @Author dangcang
 * @Date 2021/11/14 11:32 上午
 **/
@AdvancedFeignClient
public interface RemoteOrderExtraReadService {

    /**
     * 订单扩展信息查询
     * @param param
     * @return
     * @throws BizException
     */
    List<OrderExtraDTO> getOrderExtraList(OrderExtraQueryParam param) throws BizException;

    /**
     * 通过订单号列表批量获取
     * @param orderCodeList
     * @return
     * @throws BizException
     */
    List<OrderExtraDTO> batchOrderExtraByOrderCodeList(List<String> orderCodeList) throws BizException;
}