package cn.com.duiba.cloud.order.service.api.utils;

import cn.com.duiba.cloud.order.service.api.constant.OrderCodeConstant;
import cn.com.duiba.cloud.order.service.api.enums.OrderTypeEnum;

import java.util.Map;
import java.util.Objects;

/**
 * @Description 订单号生成/解码类
 * @Author dangcang
 * @Date 2021/12/17 2:27 下午
 **/
public class OrderCodeUtil {

    private OrderCodeUtil() {
    }

    /**
     * 订单号生成方法 13位时间戳 + userId后6位 + 发号器(至少8位)
     * @param id
     * @param time
     * @param selfDefinedParameter
     * @return
     */
    public static String buildOrderCode(String id, String time, Map<String,String> selfDefinedParameter) {

        StringBuilder builder = new StringBuilder();
        char[] timeArray = time.toCharArray();
        String userId = selfDefinedParameter.get(OrderCodeConstant.ORDER_CODE_PARAM_USER_ID);
        userId = buildIdLength(Long.valueOf(userId), OrderCodeConstant.ORDER_CODE_PARAM_USER_ID_LENGTH);
        Integer orderType = Integer.valueOf(selfDefinedParameter.get(OrderCodeConstant.ORDER_CODE_PARAM_ORDER_TYPE));
        if (Objects.equals(orderType, OrderTypeEnum.PURCHASE.getType())) {
            builder.append(OrderCodeConstant.PURCHASE_TYPE_PREFIX);
        }
        char[] userIdArray = userId.toCharArray();
        builder.append(timeArray[0]);
        for (int i = 1; i < time.length(); i++) {
            builder.append(timeArray[i]);
            if (i % 2 == 1) {
                builder.append(userIdArray[i / 2]);
            }
        }
        builder.append(id);

        return builder.toString();
    }

    /**
     * 获取指定长度 不足为补0 超过返回原长
     * @param id
     * @param length
     * @return
     */
    public static String buildIdLength(Long id, int length) {
        String idStr = id.toString();
        if (idStr.length() >= length) {
            return idStr.substring(0, length);
        }
        StringBuilder builder = new StringBuilder();
        int def = length - idStr.length();
        for (int i = 0; i < def; i++) {
            builder.append(0);
        }
        builder.append(id);
        return builder.toString();
    }

    /**
     * 是否是toB订单
     * @param orderCode
     * @return
     */
    public static boolean toB(String orderCode) {
        if (orderCode.startsWith(OrderCodeConstant.PURCHASE_TYPE_PREFIX)) {
            return true;
        }
        return false;
    }

    /**
     * 订单号解码userId
     * @param orderCode
     * @return
     */
    public static String decode(String orderCode) {

        char[] arrays = orderCode.toCharArray();
        StringBuilder builder = new StringBuilder();
        int step = 3;
        int current = 2;
        int size = 0;
        while (size < OrderCodeConstant.ORDER_CODE_PARAM_USER_ID_LENGTH) {
            builder.append(arrays[current]);
            size++;
            current+=step;
        }
        return builder.toString();
    }

}