/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.order.service.api.utils;

import cn.com.duiba.cloud.order.service.api.constant.OrderCodeConstant;
import cn.com.duiba.cloud.order.service.api.enums.OrderTypeEnum;
import java.util.Map;
import java.util.Objects;

public class OrderCodeUtil {
    private OrderCodeUtil() {
    }

    public static String buildOrderCode(String id, String time, Map<String, String> selfDefinedParameter) {
        StringBuilder builder = new StringBuilder();
        char[] timeArray = time.toCharArray();
        String userId = selfDefinedParameter.get("userId");
        userId = OrderCodeUtil.buildIdLength(Long.valueOf(userId), OrderCodeConstant.ORDER_CODE_PARAM_USER_ID_LENGTH);
        Integer orderType = Integer.valueOf(selfDefinedParameter.get("orderType"));
        if (Objects.equals(orderType, OrderTypeEnum.PURCHASE.getType())) {
            builder.append("P");
        }
        char[] userIdArray = userId.toCharArray();
        builder.append(timeArray[0]);
        for (int i = 1; i < time.length(); ++i) {
            builder.append(timeArray[i]);
            if (i % 2 != 1) continue;
            builder.append(userIdArray[i / 2]);
        }
        builder.append(id);
        return builder.toString();
    }

    public static String buildIdLength(Long id, int length) {
        String idStr = id.toString();
        if (idStr.length() >= length) {
            return idStr.substring(0, length);
        }
        StringBuilder builder = new StringBuilder();
        int def = length - idStr.length();
        for (int i = 0; i < def; ++i) {
            builder.append(0);
        }
        builder.append(id);
        return builder.toString();
    }

    public static boolean toB(String orderCode) {
        return orderCode.startsWith("P");
    }

    public static String decode(String orderCode) {
        char[] arrays = orderCode.toCharArray();
        StringBuilder builder = new StringBuilder();
        int step = 3;
        int current = 2;
        int size = 0;
        while (size < OrderCodeConstant.ORDER_CODE_PARAM_USER_ID_LENGTH) {
            builder.append(arrays[current]);
            ++size;
            current += step;
        }
        return builder.toString();
    }
}

