/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import java.util.Arrays;
import java.util.List;

public enum AccountTypeEnum {
    VIRTUAL_BANK(1, "\u865a\u62df\u94f6\u884c", "payment_virtual_bank"),
    TEMP_BALANCE(2, "\u4e34\u65f6\u8d26\u6237", "payment_temp_balance"),
    RESIDUE(3, "\u8d27\u6b3e", "payment_residue"),
    SUPPLY_PAYMENT(4, "\u4f9b\u8d27\u6b3e", "payment_supply_payment"),
    SERVICE_FEE(5, "\u670d\u52a1\u8d39", "payment_service_fee"),
    CREDIT_SXZH(200, "\u6388\u4fe1\u8d26\u6237", "payment_credit_sxzh"),
    CREDIT_QYZS(201, "\u6743\u76ca\u8d60\u9001", "payment_credit_qyzs"),
    CREDIT_BZXJ(202, "\u5305\u88c5\u73b0\u91d1", "payment_credit_bzxj"),
    CREDIT_BZSX(203, "\u5305\u88c5\u6388\u4fe1", "payment_credit_bzsx");

    private Integer value;
    private String desc;
    private String measureType;

    private AccountTypeEnum(Integer value, String desc, String measureType) {
        this.value = value;
        this.desc = desc;
        this.measureType = measureType;
    }

    public static String getDesc(int value) {
        for (AccountTypeEnum item : AccountTypeEnum.values()) {
            if (item.value != value) continue;
            return item.desc;
        }
        return "";
    }

    public static AccountTypeEnum valueOf(Integer value) {
        for (AccountTypeEnum param : AccountTypeEnum.values()) {
            if (!param.getValue().equals(value)) continue;
            return param;
        }
        return null;
    }

    public byte getByteValue() {
        return this.value.byteValue();
    }

    public static List<Integer> getCreditAccountType() {
        return Arrays.asList(AccountTypeEnum.CREDIT_SXZH.value, AccountTypeEnum.CREDIT_QYZS.value, AccountTypeEnum.CREDIT_BZXJ.value, AccountTypeEnum.CREDIT_BZSX.value);
    }

    public static List<Integer> getWithdrawAccountType() {
        return Arrays.asList(AccountTypeEnum.RESIDUE.value, AccountTypeEnum.SUPPLY_PAYMENT.value, AccountTypeEnum.SERVICE_FEE.value);
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getMeasureType() {
        return this.measureType;
    }
}

