/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import cn.com.duiba.cloud.duiba.payment.service.api.enums.PayBizTypeEnum;

public enum TransferSceneEnum {
    TRANSFER(1, "\u8f6c\u8d26"),
    RECHARGE(2, "\u5145\u503c"),
    DEDUCTION(3, "\u6263\u6b3e"),
    FROZEN(4, "\u51bb\u7ed3"),
    THAW(5, "\u89e3\u51bb");

    private Integer value;
    private String desc;

    private TransferSceneEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (TransferSceneEnum item : TransferSceneEnum.values()) {
            if (item.value != value) continue;
            return item.desc;
        }
        return "";
    }

    public static TransferSceneEnum bizTypeToScene(PayBizTypeEnum payBizType) {
        if (PayBizTypeEnum.RECHARGE == payBizType) {
            return RECHARGE;
        }
        if (PayBizTypeEnum.TRANSFER == payBizType) {
            return TRANSFER;
        }
        if (PayBizTypeEnum.DEDUCTION == payBizType) {
            return DEDUCTION;
        }
        if (PayBizTypeEnum.FROZEN == payBizType) {
            return FROZEN;
        }
        if (PayBizTypeEnum.THAW == payBizType) {
            return THAW;
        }
        return null;
    }

    public static TransferSceneEnum valueOf(Integer value) {
        for (TransferSceneEnum param : TransferSceneEnum.values()) {
            if (!param.getValue().equals(value)) continue;
            return param;
        }
        return null;
    }

    public byte getByteValue() {
        return this.value.byteValue();
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }
}

