/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 业务角色
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/8 10:50 上午
 **/
@Getter
public enum PayBizRoleEnum {
    PLATFORM(1, "平台"),
    SELLER(2, "卖家"),
    BUYER(3, "买家"),
    SUPPLIER(4, "供货商"),
    OUT_ACCOUNT(5, "出账方"),
    IN_ACCOUNT(6, "入账方"),

    ;

    private Integer value;

    private String desc;

    PayBizRoleEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayBizRoleEnum item : PayBizRoleEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static PayBizRoleEnum valueOf(Integer value) {
        for (PayBizRoleEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
