/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * 支付方式
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/2 3:50 下午
 **/
@Getter
public enum PayMethodEnum {
    /**
     * 支付方式
     */
    MOCK(-1, "模拟"),
    WXPAY(1, "微信"),
    ALIPAY(2, "支付宝"),
    BALANCE(3, "余额"),
    // SUBSIDY 仅在消费项目中使用，不透出给用户
    SUBSIDY(4, "补贴"),

    /**
     * 人工方式
     */
    MANUAL_BANK(5, "人工-银行"),
    MANUAL_ALIPAY(6, "人工-支付宝"),
    MANUAL_WXPAY(7, "人工-微信"),
    MANUAL_OTHER(8, "人工-其它"),
    ;


    private Integer value;

    private String desc;

    PayMethodEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayMethodEnum item : PayMethodEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    /**
     * 默认支付方式
     *
     * @return
     */
    public static List<PayMethodEnum> getDefaultPayMethod() {
        return Arrays.asList(PayMethodEnum.ALIPAY, PayMethodEnum.WXPAY);
    }

    public static PayMethodEnum valueOf(Integer value) {
        for (PayMethodEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
