package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.cloud.duiba.payment.service.api.model.PayUserBase;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.NonNull;

import java.util.List;
import java.util.Set;

/**
 * 人工扣减单请求
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/8 2:11 下午
 **/
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@Data
public class ManualDeductionOrderParam extends PayUserBase {

    private static final long serialVersionUID = -3056977470113836433L;
    /**
     * 扣减编号
     */
    @NonNull
    private String deductionNo;

    /**
     * 扣减金额（传正数）
     * deductionAmount
     */
    @NonNull
    private Long deductionAmount;

    /**
     * 扣减原因，会在用户账单中看到，请严格处理
     */
    private String deductionReason;

    /**
     * 扣减账户顺序
     */
    private List<Integer> deductionAccountSort;
}
