package cn.com.duiba.cloud.duiba.payment.service.api.param;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import java.io.Serializable;

/**
 * 退款统一下单
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/18 11:46 上午
 **/
@Data
@NoArgsConstructor
@RequiredArgsConstructor
public class RefundOrderParam implements Serializable {
    private static final long serialVersionUID = -2839472864075837518L;
    /**
     * 退款编号
     */
    @NonNull
    private String refundNo;

    /**
     * 退款金额
     * refundAmount
     */
    @NonNull
    private Long refundAmount;

    /**
     * 支付的业务单号
     */
    @NonNull
    private String payBizNo;

    /**
     * 支付的业务版本
     */
    @NonNull
    private Integer payBizVersion;


    /**
     * 退款原因，会在用户账单中看到，请严格处理
     */
    @NonNull
    private String refundReason;
}
