package cn.com.duiba.cloud.duiba.payment.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.payment.service.api.param.app.AppOrderCreateParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.app.AppOrderDoneParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.app.AppOrderFailParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.app.AppOrderRefundParam;

/**
 * 应用订单（应用向兑吧采购商品）
 * 创建订单：创建支付单，冻结资金
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/5/12 9:51 上午
 **/
@AdvancedFeignClient
public interface RemoteAppOrderService {

    /**
     * 订单创建
     * 冻结金额下单
     *
     * @param param
     * @return
     * @throws BizException
     */
    Long createOrder(AppOrderCreateParam param) throws BizException;


    /**
     * 交易成功
     * 冻结-》扣减
     *
     * @param param
     * @throws BizException
     */
    void orderDone(AppOrderDoneParam param) throws BizException;


    /**
     * 交易失败
     * 冻结-》解冻
     *
     * @param param
     * @throws BizException
     */
    void orderFail(AppOrderFailParam param) throws BizException;

    /**
     * 订单退款
     * 已扣减-》部分退回
     *
     * @param param
     * @return
     * @throws BizException
     */
    Long orderRefund(AppOrderRefundParam param) throws BizException;


}
