/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.duiba.payment.service.api.enums.PayAccountTypeEnum;
import java.text.MessageFormat;

public enum PayCreditTypeEnum {
    CREDIT_SXZH(1, "\u6388\u4fe1\u8d26\u6237"),
    CREDIT_QYZS(2, "\u6743\u76ca\u8d60\u9001"),
    CREDIT_LSSX(3, "\u4e34\u65f6\u6388\u4fe1\u8d26\u6237");

    private Integer value;
    private String desc;

    private PayCreditTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayCreditTypeEnum item : PayCreditTypeEnum.values()) {
            if (item.value != value) continue;
            return item.desc;
        }
        return "";
    }

    public static PayCreditTypeEnum valueOf(Integer value) {
        for (PayCreditTypeEnum param : PayCreditTypeEnum.values()) {
            if (!param.getValue().equals(value)) continue;
            return param;
        }
        return null;
    }

    public static PayCreditTypeEnum getCreditTypeByAccountType(Integer accountType) throws BizException {
        if (PayAccountTypeEnum.CREDIT_SXZH.getValue().equals(accountType)) {
            return CREDIT_SXZH;
        }
        if (PayAccountTypeEnum.CREDIT_QYZS.getValue().equals(accountType)) {
            return CREDIT_QYZS;
        }
        if (PayAccountTypeEnum.CREDIT_LSSX.getValue().equals(accountType)) {
            return CREDIT_LSSX;
        }
        throw new BizException(MessageFormat.format("\u6682\u4e0d\u652f\u6301\u8be5\u8d26\u6237\u7c7b\u578b\u7684\u6388\u4fe1\u7c7b\u578b\u8f6c\u6362 accountType:{0}", accountType));
    }

    public byte getByteValue() {
        return this.value.byteValue();
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }
}

