/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import cn.com.duiba.cloud.duiba.payment.service.api.enums.PayBizTypeEnum;

public enum PayTransferSceneEnum {
    TRANSFER(1, "\u8f6c\u8d26"),
    RECHARGE_MANUAL(2, "\u4eba\u5de5\u5145\u503c"),
    RECHARGE_ONLINE(3, "\u5728\u7ebf\u5145\u503c"),
    DEDUCTION_MANUAL(4, "\u4eba\u5de5\u6263\u6b3e"),
    FROZEN(5, "\u51bb\u7ed3"),
    THAW(6, "\u89e3\u51bb");

    private Integer value;
    private String desc;

    private PayTransferSceneEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayTransferSceneEnum item : PayTransferSceneEnum.values()) {
            if (item.value != value) continue;
            return item.desc;
        }
        return "";
    }

    public static PayTransferSceneEnum bizTypeToScene(PayBizTypeEnum payBizType) {
        if (PayBizTypeEnum.RECHARGE_GIVE == payBizType || PayBizTypeEnum.RECHARGE_MANUAL == payBizType || PayBizTypeEnum.RECHARGE_CREDIT == payBizType) {
            return RECHARGE_ONLINE;
        }
        if (PayBizTypeEnum.RECHARGE_ONLINE == payBizType) {
            return RECHARGE_MANUAL;
        }
        if (PayBizTypeEnum.TRANSFER == payBizType) {
            return TRANSFER;
        }
        if (PayBizTypeEnum.DEDUCTION_MANUAL == payBizType) {
            return DEDUCTION_MANUAL;
        }
        if (PayBizTypeEnum.FROZEN == payBizType) {
            return FROZEN;
        }
        if (PayBizTypeEnum.THAW == payBizType) {
            return THAW;
        }
        return null;
    }

    public static PayTransferSceneEnum valueOf(Integer value) {
        for (PayTransferSceneEnum param : PayTransferSceneEnum.values()) {
            if (!param.getValue().equals(value)) continue;
            return param;
        }
        return null;
    }

    public byte getByteValue() {
        return this.value.byteValue();
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }
}

