package cn.com.duiba.cloud.duiba.payment.service.api.dto;

import cn.com.duiba.cloud.duiba.payment.service.api.model.PayTransferExtra;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author sunyan
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class OnlinePayDTO extends PayTransferExtra implements Serializable {
    private static final long serialVersionUID = -1361719880074544147L;
    /**
     * 充值类型 枚举:company self
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.LianlianAccountTypeEnum
     */
    private String accountType;
    /**
     * 公司的名称或者个人用户的真实姓名
     */
    private String name;
    /**
     * 公司的营业执照号
     */
    private String license;
    /**
     * 公司的执照到期时间
     */
    private String time;
    /**
     * 个人用户的身份证号
     */
    private String idNum;
    /**
     * 充值银行
     */
    private String bank;
}
