package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.cloud.duiba.payment.service.api.dto.WithdrawAccountDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.enums.PayAccountTypeEnum;
import cn.com.duiba.cloud.duiba.payment.service.api.model.PayUserBase;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

/**
 * 提现单请求
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/8 2:11 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@RequiredArgsConstructor
public class WithdrawApplyParam extends PayUserBase {
    private static final long serialVersionUID = -5926780384540920781L;

    /**
     * 账户类型
     *
     * @see PayAccountTypeEnum
     */
    @NonNull
    private Integer accountType;

    /**
     * 提现金额（分）
     */
    @NonNull
    private Long amount;

    /**
     * 支付方式
     */
    @NonNull
    private Integer payMethod;

    /**
     * 账户信息
     */
    @NonNull
    private WithdrawAccountDTO accountInfo;

}
