package cn.com.duiba.cloud.duiba.payment.service.api.param.unifiedorder;

import cn.com.duiba.cloud.duiba.payment.service.api.model.PayUserBase;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import java.util.List;

/**
 * 应用订单
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/05/18 11:46 上午
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@RequiredArgsConstructor
public class AppOrderParam extends PayUserBase {
    private static final long serialVersionUID = -2839472864075837518L;

    private Integer accountType;

    /**
     * 卖方用户类型
     */
    private Integer toUserType;

    /**
     * 卖方用户id
     */
    private Long toUserId;

    /**
     * 业务编号
     */
    private String bizNo;

    /**
     * 父类业务编号
     */
    private String parentBizNo;

    /**
     * 相关主订单
     */
    private String mainOrder;

    /**
     * 相关子订单
     */
    private List<String> subOrderList;

    /**
     * 开发者订单号
     */
    private String developOrder;

    /**
     * 金额
     */
    @NonNull
    private Long amount;

    /**
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayOrderStatusEnum
     */
    private Integer orderStatus;

    /**
     * 备注
     */
    private String memo;

    /**
     * 支付账户顺序
     */
    private List<Integer> payAccountSort;
}
