package cn.com.duiba.cloud.duiba.payment.service.api.param.unifiedorder;

import cn.com.duiba.cloud.duiba.payment.service.api.enums.PayBizTypeEnum;
import cn.com.duiba.cloud.duiba.payment.service.api.model.PayUserBase;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 统一下单基础类
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/5 11:00 上午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class SaleOrderParam extends PayUserBase {

    private static final long serialVersionUID = -4270205905759478956L;

    /**
     * 卖家用户类型（租户、普通用户等）
     * user_type
     */
    @NotNull
    private Integer toUserType;

    /**
     * 卖家用户id
     * to_user_id
     */
    @NotNull
    private Long toUserId;

    /**
     * 总金额
     * amount
     */
    @NotNull
    private Long amount;

    /**
     * 过期时间
     * expired_time
     */
    @NotNull
    private Date expiredTime;

    /**
     * 业务类型
     */
    @NotNull
    private Integer bizType = PayBizTypeEnum.ORDER_PAY.getValue();

    /**
     * 业务单号（合并下单时为支付系统生成）
     * biz_no
     */
    @NotNull
    private String bizNo;

    /**
     * 业务版本
     * biz_version
     */
    private Integer bizVersion;
}
