/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class MoneyUtils {
    public static long add(long a, long b) {
        return BigDecimal.valueOf(a).add(BigDecimal.valueOf(b)).longValue();
    }

    public static long subtract(long a, long b) {
        return BigDecimal.valueOf(a).subtract(BigDecimal.valueOf(b)).longValue();
    }

    public static long multiply(long a, long b) {
        return BigDecimal.valueOf(a).multiply(BigDecimal.valueOf(b)).longValue();
    }

    public static long divide(long a, long b) {
        return BigDecimal.valueOf(a).divide(BigDecimal.valueOf(b)).setScale(0, 1).longValue();
    }

    public static long minus(long a) {
        return -MoneyUtils.abs(a);
    }

    public static long abs(long a) {
        return Math.abs(a);
    }

    public static BigDecimal fen2yuan(Long fenMoney) {
        if (null == fenMoney) {
            return BigDecimal.ZERO.setScale(2);
        }
        return BigDecimal.valueOf(fenMoney).divide(BigDecimal.valueOf(100L), 2, RoundingMode.DOWN);
    }

    public static Long yuan2fen(Double yuanMoney) {
        if (null == yuanMoney) {
            return 0L;
        }
        return new BigDecimal("" + yuanMoney).multiply(BigDecimal.valueOf(100L)).longValue();
    }

    public static String fen2yuanStr(Long fenMoney) {
        return MoneyUtils.fen2yuan(fenMoney).toPlainString();
    }

    public static String yuan2fenStr(Double yuanMoney) {
        return MoneyUtils.yuan2fen(yuanMoney).toString();
    }
}

