package cn.com.duiba.cloud.duiba.payment.service.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * 三方转账请求
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/7/14 8:19 下午
 **/
@Data
public class ThirdTransferResultDTO implements Serializable {

    private static final long serialVersionUID = 2255718289724367423L;
    /**
     * 支付方式
     */
    private Integer payMethod;

    /**
     * 转账金额
     */
    private Long transferAmount;

    /**
     * 业务编号
     */
    private String bizNo;

    /**
     * 三方返回的交易编号
     **/
    private String thirdTradeNo;

    /**
     * 我们对三方暴露的交易编号
     **/
    private String outTradeNo;

    /**
     * 状态
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayStatusEnum
     */
    private Integer status;

    /**
     * 三方返回的状态
     */
    private String thirdStatus;

    /**
     * 网关返回码描述
     */
    private String msg;

    /**
     * 业务返回码
     */
    private String subMsg;
}
