/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 支付业务动作类型
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/9 10:50 上午
 **/
@Getter
public enum PayBizActionEnum {
    /**
     * 支付业务动作类型,用于资金操作的业务区分
     */
    PAY(1, "支付"),
    WITHDRAW(2, "提现"),
    REFUND(3, "退款"),
    ORDER_DONE(4, "订单完成"),
    RECHARGE(5, "充值"),
    SETTLE(6, "结算"),
    TRANSFER(7, "账户转账"),
    BALANCE_PAY(8, "余额支付"),
    DEDUCTION(9, "账户扣减"),
    APP_ORDER(10, "应用支付"),
    OVERDUE_CREDIT(11, "信用过期"),
    ;


    private Integer value;

    private String desc;

    PayBizActionEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayBizActionEnum item : PayBizActionEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static PayBizActionEnum valueOf(Integer value) {
        for (PayBizActionEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
