/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 支付业务类型，有相应独立单号的
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/2 3:50 下午
 **/
@Getter
public enum PayBizTypeEnum {
    /**
     * 业务类型，在订单，资金流水都有涉及
     */
    ORDER_PAY(1, "订单交易"),
    REFUND(2, "交易退款"),
    // 对应用维度的充值
    RECHARGE_MANUAL(3, "人工充值"),

    // 对应用维度的充值
    RECHARGE_ONLINE(4, "在线充值"),
    RECHARGE_GIVE(5, "赠送充值"),
    RECHARGE_CREDIT(6, "授信提额"),
    DEDUCTION_MANUAL(7, "人工扣款"),
    OVERDUE_CREDIT(8, "信用过期"),

    // 对C端用户的转账
    THIRD_TRANSFER_TO_C(9, "三方转账"),

    // 没有在业务使用
    TRANSFER(10, "转账"),
    WITHDRAW(11, "提现"),
    FROZEN(12, "冻结"),
    THAW(13, "解冻"),
    ;


    private Integer value;

    private String desc;

    PayBizTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayBizTypeEnum item : PayBizTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static PayBizTypeEnum valueOf(Integer value) {
        for (PayBizTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
