/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 预算来源
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/9 10:50 上午
 **/
@Getter
public enum PayBudgetSourceEnum {
    /**
     * 预算类型
     */
    OWN(1, "自有"),

    DUIBA(2, "兑吧"),
    ;


    private Integer value;

    private String desc;

    PayBudgetSourceEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayBudgetSourceEnum item : PayBudgetSourceEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static PayBudgetSourceEnum valueOf(Integer value) {
        for (PayBudgetSourceEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
