package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 支付调用场景
 * @author huangguosheng@duiba.com.cn
 * @date 2022/7/29 2:29 下午
 **/
@Getter
public enum PayInvokeSceneEnum {
    /**
     * 应用内h5
     */
    APP_H5(1, "应用内-H5"),
    WX_PUBLIC(2, "微信公众号"),
    WX_MINI(3, "微信小程序"),
    ALI(4, "支付宝"),

    ;


    private Integer value;

    private String desc;

    PayInvokeSceneEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayInvokeSceneEnum item : PayInvokeSceneEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }


    public static PayInvokeSceneEnum valueOf(Integer value) {
        for (PayInvokeSceneEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
