package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 支付状态 [0: 待支付; 1:支付成功; 2:支付失败]
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/2 3:50 下午
 **/
@Getter
public enum PayStatusEnum {

    /**
     * 支付状态
     */
    WAIT(0, "待支付"),
    SUCCESS(1, "支付成功"),
    FAILURE(2, "支付失败");


    private Integer value;

    private String desc;

    PayStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayStatusEnum item : PayStatusEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static PayStatusEnum valueOf(Integer value) {
        for (PayStatusEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
