/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.enums;

import lombok.Getter;

/**
 * 转账场景
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/2 3:50 下午
 **/
@Getter
public enum PayTransferSceneEnum {
    /**
     * 转账场景 （转账、充值、扣款）
     */
    TRANSFER(1, "转账"),
    RECHARGE_MANUAL(2, "人工充值"),
    RECHARGE_ONLINE(3, "在线充值"),
    DEDUCTION_MANUAL(4, "人工扣款"),
    DEDUCTION_OVERDUE(5, "过期扣款"),
    FROZEN(6, "冻结"),
    THAW(7, "解冻"),
    ;


    private Integer value;

    private String desc;

    PayTransferSceneEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (PayTransferSceneEnum item : PayTransferSceneEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    /**
     * 业务类型 与 转账场景转换
     *
     * @param payBizType
     * @return
     */
    public static PayTransferSceneEnum bizTypeToScene(PayBizTypeEnum payBizType) {
        if (PayBizTypeEnum.RECHARGE_GIVE == payBizType || PayBizTypeEnum.RECHARGE_MANUAL == payBizType
                 || PayBizTypeEnum.RECHARGE_CREDIT == payBizType) {
            return PayTransferSceneEnum.RECHARGE_ONLINE;
        }
        if(PayBizTypeEnum.RECHARGE_ONLINE == payBizType){
            return PayTransferSceneEnum.RECHARGE_MANUAL;
        }
        if (PayBizTypeEnum.TRANSFER == payBizType) {
            return PayTransferSceneEnum.TRANSFER;
        }
        if (PayBizTypeEnum.THIRD_TRANSFER_TO_C == payBizType) {
            return PayTransferSceneEnum.TRANSFER;
        }
        if (PayBizTypeEnum.DEDUCTION_MANUAL == payBizType) {
            return PayTransferSceneEnum.DEDUCTION_MANUAL;
        }
        if (PayBizTypeEnum.FROZEN == payBizType) {
            return PayTransferSceneEnum.FROZEN;
        }
        if (PayBizTypeEnum.THAW == payBizType) {
            return PayTransferSceneEnum.THAW;
        }
        return null;
    }

    public static PayTransferSceneEnum valueOf(Integer value) {
        for (PayTransferSceneEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
