package cn.com.duiba.cloud.duiba.payment.service.api.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 订单支付通知参数
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/6 4:45 下午
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MqOrderPayNotifyModel implements Serializable {
    private static final long serialVersionUID = -6989663737979196480L;

    /**
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayBizTypeEnum
     */
    private Integer bizType;

    /**
     * 业务单号
     */
    private String bizNo;

    /**
     * 业务版本好
     */
    private Integer bizVersion;

    /**
     * 支付状态
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayStatusEnum
     */
    private Integer payStatus;

    /**
     * 支付方式
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayMethodEnum
     */
    private Integer payMethod;

    /**
     * 支付金额（分）
     */
    private Long payAmount;

    /**
     * 对外支付单号
     */
    private String outTradeNo;

    /**
     * 三方订单号
     */
    private String thirdTradeNo;

    /**
     * 返回结果信息
     */
    private String msg;
}
