package cn.com.duiba.cloud.duiba.payment.service.api.param;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 收银台查询接口
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/7/29 2:27 下午
 **/
@Data
public class CashierQueryParam implements Serializable {
    private static final long serialVersionUID = 1588072516402946959L;

    @NotNull(message = "支付Key不能为空")
    private String payKey;

    /**
     * 支付调用场景
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayInvokeSceneEnum
     */
    private String payInvokeScene;
}
